/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************

   In this tutorial is presented how to extend a Game Object class.
   But unlike in previous examples, we won't base on Character/Item or other classes.
   This time we'll extend the most base class - Game::Obj.

/******************************************************************************/
struct NewObj : Game::Obj // extend Game Object
{
   Vec position; // the class will contain only position

   // provide necessary methods required by Game::Obj :
      virtual void create(Game::ObjParams &obj); // extend default creation

      virtual Vec  pos(        ){return position    ;} // get position
      virtual void pos(Vec &pos){     T.position=pos;} // set position

      virtual Matrix matrix(              ){return position           ;} // get matrix
      virtual void   matrix(Matrix &matrix){     T.position=matrix.pos;} // set matrix

      virtual Bool update(){return true;} // object update
      virtual void draw  ();              // object draw

      virtual void disable(){}
      virtual void  enable(){}

   // constructor
   NewObj();

   // io methods
   virtual void save(File &f);
   virtual Bool load(File &f);
};
/******************************************************************************/
NewObj::NewObj() // initialize values in constructor
{
   position.zero();
}
void NewObj::create(Game::ObjParams &obj)
{
   // now setup custom parameters from 'obj'
   position=obj.matrixFinal().pos; // obtain our 'position' member from 'obj'
}
/******************************************************************************/
void NewObj::draw()
{
   switch(Renderer())
   {
      case RM_SOLID:
      case RM_LIGHT:
         MatrixSet();
         Ball(1,position).draw(ARGB(0,255,255,255)); // draw white ball at objects position
      break;
   }
}
/******************************************************************************/
void NewObj::save(File &f)
{
   __super::save(f); // default save

   f<<position; // save custom parameters
}
Bool NewObj::load(File &f)
{
   if(__super::load(f)) // if default load was successful
   {
      f>>position; // load custom parameters
      return true; // return success
   }
   return false; // return failure
}
/******************************************************************************/
// MAIN
/******************************************************************************/
Game::ObjMemx<NewObj> NewObjs; // container for objects
/******************************************************************************/
void InitPre()
{
   App.name="Game::Obj class";
   App.flag=APP_FULL_TOGGLE|APP_MS_EXCLUSIVE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).ambPower(0.3);

   ViewportFull.range=50;
   Cam.at.set(16,0,16);
   Cam.dist = 10;
   Cam.pitch=-PI_3;
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower();
   Sky    .set   ();

   Game::World.init   (                     )
              .setType(NewObjs,OBJ_ITEM     ) // use OBJ_ITEM type because objects in the world we're using are saved with OBJ_ITEM type
              .New    ("world/custom params");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   Game::World.update(Cam.at);

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
